MoreVehZones = MoreVehZones or {}

function MoreVehZones.angledVehSpawnPositionBetween(vehicle)
	if not vehicle:getChunk():isNewChunk() then return end
	local pos = vehicle:getSquare()
	local zone = getVehicleZoneAt(pos:getX(), pos:getY(), pos:getZ())
	if zone ~= nil then
		local zoneName
		if zone:getName() == "" then
			zoneName = "parkingstall"
		else
			zoneName = zone:getName()
		end
		if VehicleZoneDistribution[zoneName] ~= nil then
			if VehicleZoneDistribution[zoneName].positionAngles ~= nil and not VehicleZoneDistribution[zoneName].randomAngle then
				if VehicleZoneDistribution[zoneName].positionAngles[3] == true then
					local angle = ZombRandFloat(VehicleZoneDistribution[zoneName].positionAngles[1], VehicleZoneDistribution[zoneName].positionAngles[2])
					if tostring(vehicle:getDir()) == "N" or tostring(vehicle:getDir()) == "W" then
						vehicle:setAngles(vehicle:getAngleX(), vehicle:getAngleY()+angle, vehicle:getAngleZ())
					elseif tostring(vehicle:getDir()) == "S" or tostring(vehicle:getDir()) == "E" then
						vehicle:setAngles(vehicle:getAngleX(), vehicle:getAngleY()-angle, vehicle:getAngleZ())
					end
				end
			end
		end
	end
end

function MoreVehZones.angledVehSpawnPosition(vehicle)
	if not vehicle:getChunk():isNewChunk() then return end
	local pos = vehicle:getSquare()
	local zone = getVehicleZoneAt(pos:getX(), pos:getY(), pos:getZ())
	if zone ~= nil then
		local zoneName
		if zone:getName() == "" then
			zoneName = "parkingstall"
		else
			zoneName = zone:getName()
		end
		if VehicleZoneDistribution[zoneName] ~= nil then
			if VehicleZoneDistribution[zoneName].positionAngles ~= nil and not VehicleZoneDistribution[zoneName].randomAngle then
				if VehicleZoneDistribution[zoneName].positionAngles[3] ~= true then
					local angles = VehicleZoneDistribution[zoneName].positionAngles
					local angle = angles[ZombRand(#angles)+1]
					if tostring(vehicle:getDir()) == "N" or tostring(vehicle:getDir()) == "W" then
						vehicle:setAngles(vehicle:getAngleX(), vehicle:getAngleY()+angle, vehicle:getAngleZ())
					elseif tostring(vehicle:getDir()) == "S" or tostring(vehicle:getDir()) == "E" then
						vehicle:setAngles(vehicle:getAngleX(), vehicle:getAngleY()-angle, vehicle:getAngleZ())
					end
				end
			end
		end
	end
end

Events.OnSpawnVehicleEnd.Add(MoreVehZones.angledVehSpawnPosition)
Events.OnSpawnVehicleEnd.Add(MoreVehZones.angledVehSpawnPositionBetween)